/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import java.util.Objects;

public class BasicSpec
implements Cloneable,
InformationSetSerializable {
    private TsPeriodSelector span_ = new TsPeriodSelector();
    private boolean preprocess_ = true;
    private boolean preliminaryCheck_ = true;
    public static final String SPAN = "span";
    public static final String PREPROCESS = "preprocess";
    public static final String PRELIMINARYCHECK = "preliminarycheck";
    private static final String[] DICTIONARY = new String[]{"span", "preprocess", "preliminarycheck"};

    public void reset() {
        this.span_ = new TsPeriodSelector();
        this.preprocess_ = true;
        this.preliminaryCheck_ = true;
    }

    public BasicSpec clone() {
        try {
            BasicSpec spec = (BasicSpec)super.clone();
            spec.span_ = this.span_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    public void setSpan(TsPeriodSelector value) {
        if (value == null) {
            this.span_.all();
        } else {
            this.span_ = value;
        }
    }

    public boolean isPreprocessing() {
        return this.preprocess_;
    }

    public void setPreprocessing(boolean value) {
        this.preprocess_ = value;
    }

    public boolean isPreliminaryCheck() {
        return this.preliminaryCheck_;
    }

    public void setPreliminaryCheck(boolean value) {
        this.preliminaryCheck_ = value;
    }

    public boolean isDefault() {
        if (this.span_.getType() != PeriodSelectorType.All) {
            return false;
        }
        return this.preprocess_ && this.preliminaryCheck_;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.span_);
        hash = 83 * hash + (this.preprocess_ ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof BasicSpec && this.equals((BasicSpec)obj);
    }

    private boolean equals(BasicSpec spec) {
        return Objects.equals(spec.span_, this.span_) && this.preprocess_ == spec.preprocess_ && this.preliminaryCheck_ == spec.preliminaryCheck_;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.span_.getType() != PeriodSelectorType.All) {
            info.add(SPAN, this.span_);
        }
        if (verbose || !this.preprocess_) {
            info.add(PREPROCESS, Boolean.valueOf(this.preprocess_));
        }
        if (verbose || !this.preliminaryCheck_) {
            info.add(PRELIMINARYCHECK, Boolean.valueOf(this.preliminaryCheck_));
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Boolean preliminaryChecks;
            Boolean preprocess;
            this.reset();
            TsPeriodSelector span = info.get(SPAN, TsPeriodSelector.class);
            if (span != null) {
                this.span_ = span;
            }
            if ((preprocess = info.get(PREPROCESS, Boolean.class)) != null) {
                this.preprocess_ = preprocess;
            }
            if ((preliminaryChecks = info.get(PRELIMINARYCHECK, Boolean.class)) != null) {
                this.preliminaryCheck_ = preliminaryChecks;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

