/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import java.time.DayOfWeek;
import java.util.Arrays;

public class DayClustering {
    private final int[] groups;
    private static final int[] TD7_IDX = new int[]{1, 2, 3, 4, 5, 6, 0};
    private static final int[] TD2_IDX = new int[]{1, 1, 1, 1, 1, 0, 0};
    private static final int[] TD3_IDX = new int[]{1, 1, 1, 1, 1, 2, 0};
    private static final int[] TD3C_IDX = new int[]{1, 1, 1, 1, 2, 2, 0};
    private static final int[] TD4_IDX = new int[]{1, 1, 1, 1, 2, 3, 0};
    private static final String[] SHORTNAMES = new String[]{"mon", "tue", "wed", "thu", "fri", "sat", "sun"};
    public static final DayClustering TD2 = new DayClustering(TD2_IDX);
    public static final DayClustering TD3 = new DayClustering(TD3_IDX);
    public static final DayClustering TD3c = new DayClustering(TD3C_IDX);
    public static final DayClustering TD4 = new DayClustering(TD4_IDX);
    public static final DayClustering TD7 = new DayClustering(TD7_IDX);

    public static DayClustering create(int[] groups) {
        if (groups.length != 7) {
            return null;
        }
        if (!DayClustering.checkGroups(groups)) {
            return null;
        }
        return new DayClustering(groups);
    }

    private static boolean checkGroups(int[] groups) {
        int n = 0;
        int gr = 0;
        while (n < 7) {
            int ncur = 0;
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i] != gr) continue;
                ++ncur;
            }
            if (ncur == 0) {
                return false;
            }
            n += ncur;
            ++gr;
        }
        return gr > 1;
    }

    DayClustering(int[] groups) {
        this.groups = groups;
    }

    public int getGroup(DayOfWeek dw) {
        return this.groups[dw.getValue() - 1];
    }

    public int getGroupsCount() {
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] <= n) continue;
            n = this.groups[i];
        }
        return n + 1;
    }

    public int getGroupCount(int idx) {
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] != idx) continue;
            ++n;
        }
        return n;
    }

    public DayOfWeek[] group(int idx) {
        int n = this.getGroupCount(idx);
        DayOfWeek[] dw = new DayOfWeek[n];
        int i = 0;
        int j = 0;
        while (j < n) {
            if (this.groups[i] == idx) {
                dw[j++] = DayOfWeek.of(i + 1);
            }
            ++i;
        }
        return dw;
    }

    public int[] positions(int idx) {
        int n = 0;
        for (int i = 0; i < this.groups.length; ++i) {
            if (this.groups[i] != idx) continue;
            ++n;
        }
        int[] dw = new int[n];
        int i = 0;
        int j = 0;
        while (j < n) {
            if (this.groups[i] == idx) {
                dw[j++] = i;
            }
            ++i;
        }
        return dw;
    }

    public int[][] allPositions() {
        int n = this.getGroupsCount();
        int[][] all = new int[n][];
        for (int i = 0; i < n; ++i) {
            all[i] = this.positions(i);
        }
        return all;
    }

    public boolean isInside(DayClustering dc) {
        int n = dc.getGroupsCount();
        for (int i = 0; i < n; ++i) {
            int cur = -1;
            for (int j = 0; j < 7; ++j) {
                if (dc.groups[j] != i) continue;
                int g = this.groups[j];
                if (cur == -1) {
                    cur = g;
                    continue;
                }
                if (g == cur) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (Arrays.equals(this.groups, TD7_IDX)) {
            return "TD7";
        }
        if (Arrays.equals(this.groups, TD2_IDX)) {
            return "TD2";
        }
        if (Arrays.equals(this.groups, TD3_IDX)) {
            return "TD3";
        }
        if (Arrays.equals(this.groups, TD3C_IDX)) {
            return "TD3c";
        }
        if (Arrays.equals(this.groups, TD4_IDX)) {
            return "TD4";
        }
        StringBuilder builder = new StringBuilder();
        int ng = this.getGroupsCount();
        for (int i = 0; i < ng; ++i) {
            builder.append('{').append(this.toString(i)).append('}');
        }
        return builder.toString();
    }

    public String toString(int i) {
        StringBuilder builder = new StringBuilder();
        DayOfWeek[] gr = this.group(i);
        builder.append(SHORTNAMES[gr[0].getValue()]);
        for (int j = 1; j < gr.length; ++j) {
            builder.append(',').append(SHORTNAMES[gr[j].getValue()]);
        }
        return builder.toString();
    }

    public int[] getGroupsDefinition() {
        return this.groups;
    }
}

