/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class GraphMemBaseQueryHandler
extends SimpleQueryHandler {
    protected final TripleStore store;

    public GraphMemBaseQueryHandler(GraphMemBase graph) {
        super(graph);
        this.store = graph.store;
    }

    public ExtendedIterator objectsFor(Node p, Node o) {
        return this.bothANY(p, o) ? this.findObjects() : super.objectsFor(p, o);
    }

    public ExtendedIterator predicatesFor(Node s, Node o) {
        return this.bothANY(s, o) ? this.findPredicates() : super.predicatesFor(s, o);
    }

    public ExtendedIterator subjectsFor(Node p, Node o) {
        return this.bothANY(p, o) ? this.findSubjects() : super.subjectsFor(p, o);
    }

    private boolean bothANY(Node a, Node b) {
        return !(a != null && !a.equals(Node.ANY) || b != null && !b.equals(Node.ANY));
    }

    public ExtendedIterator findPredicates() {
        return this.store.listPredicates();
    }

    public ExtendedIterator findObjects() {
        return this.store.listObjects();
    }

    public ExtendedIterator findSubjects() {
        return this.store.listSubjects();
    }
}

