/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.BasicMethods;

import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.BasicMethods.ARS;
import keel.Algorithms.Instance_Generation.BasicMethods.AVG;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;

public class SAVG
extends AVG {
    private double percentSelection = 0.2;

    public SAVG(PrototypeSet traDataSet, double ps) {
        super(traDataSet);
        this.algorithmName = "SAVG";
        this.percentSelection = ps;
        if (ps > 1.0) {
            this.percentSelection = ps / 100.0;
        }
    }

    public SAVG(PrototypeSet traDataSet, Parameters param) {
        super(traDataSet, param);
        this.algorithmName = "SAVG";
        if (param.existMore()) {
            this.percentSelection = param.getNextAsDouble();
        }
        if (this.percentSelection > 1.0) {
            this.percentSelection /= 100.0;
        }
    }

    @Override
    public PrototypeSet reduceSet() {
        int size = (int)Math.ceil((double)this.trainingDataSet.size() * this.percentSelection);
        ARS ars = new ARS(this.trainingDataSet, size);
        PrototypeSet reduced = ars.reduceSet();
        AVG avg = new AVG(reduced);
        return avg.reduceSet();
    }

    public static void main(String[] args) {
        Parameters.setUse("SAVG", "<seed> [% initial selection]");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        double ps = 0.1;
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        SAVG.setSeed(seed);
        if (args.length == 4) {
            ps = Parameters.assertExtendedArgAsDouble(args, 3, "% of prototypes selected", 0.0, 100.0);
            ps /= 100.0;
        }
        SAVG generator = new SAVG(training, ps);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

