/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.Serializable;
import keel.Algorithms.Decision_Trees.M5.M5;
import keel.Algorithms.Decision_Trees.M5.M5Instances;

public final class InformationHandler
implements Serializable {
    boolean smooth;
    int randomSeed;
    int classcol;
    int verbosity;
    int model;
    int numFolds;
    double pruningFactor;
    String trainFile;
    String testFile;
    int lmNo;
    double deviation;
    static final String VERSION = "v1.1";

    public InformationHandler(M5Instances inst) {
        this.smooth = true;
        this.randomSeed = 1;
        this.classcol = inst.classIndex();
        this.verbosity = 0;
        this.model = 3;
        this.numFolds = 10;
        this.pruningFactor = 2.0;
        this.trainFile = null;
        this.testFile = null;
        this.lmNo = 0;
    }

    public InformationHandler(String[] argv) {
        String rest = new String();
        rest = null;
        this.classcol = -3;
        this.pruningFactor = 1.0;
        this.randomSeed = 1;
        this.model = 3;
        this.trainFile = null;
        this.testFile = null;
        this.numFolds = 0;
        this.lmNo = 0;
        if (argv.length < 1 || !argv[0].startsWith("-")) {
            M5.errorMsg("no training file specified. See -help.");
        }
        for (int count = 0; count < argv.length && argv[count].startsWith("-") && argv[count].length() >= 2; ++count) {
            char sw = argv[count].charAt(1);
            if (argv[count].length() > 2) {
                rest = argv[count].substring(2);
            } else if (argv[count].length() == 2 && count + 1 < argv.length && !argv[count + 1].startsWith("-")) {
                rest = argv[++count].toString();
            }
            block0 : switch (sw) {
                case 'c': {
                    if (rest == null) break;
                    if (rest.charAt(0) > '0' && rest.charAt(0) < ':') {
                        this.classcol = Integer.parseInt(rest) - 1;
                        break;
                    }
                    if (rest.charAt(0) == 'f') {
                        this.classcol = 0;
                        break;
                    }
                    if (rest.charAt(0) == 'l') {
                        this.classcol = -1;
                        break;
                    }
                    this.classcol = -2;
                    break;
                }
                case 'f': {
                    if (rest == null) break;
                    this.pruningFactor = Double.valueOf(rest);
                    if (!(this.pruningFactor < -0.01) && !(this.pruningFactor > 10.01)) break;
                    M5.errorMsg("pruning factor out of limit (0.0 - 10.0).\nDefault value 1.0. (0.0 - 3.0) is the recommended range.");
                    break;
                }
                case 'h': {
                    this.printValidOptions();
                }
                case 'L': {
                    this.lmNo = Integer.parseInt(rest);
                    break;
                }
                case 'o': {
                    this.model = 3;
                    if (rest == null) break;
                    switch (rest.charAt(0)) {
                        case '1': 
                        case 'L': 
                        case 'l': {
                            this.model = 1;
                            break block0;
                        }
                        case '2': 
                        case 'R': 
                        case 'r': {
                            this.model = 2;
                            break block0;
                        }
                        case '3': 
                        case 'M': 
                        case 'm': {
                            this.model = 3;
                            break block0;
                        }
                    }
                    M5.errorMsg("unknown model type -o " + rest + " . See -help");
                    System.exit(1);
                    break;
                }
                case 's': {
                    this.numFolds = 10;
                    if (rest == null) break;
                    this.randomSeed = Integer.parseInt(rest);
                    if (this.randomSeed >= 0) break;
                    M5.errorMsg("randomization seed must be >= 0. Default value is 1.");
                    break;
                }
                case 't': {
                    if (rest != null) {
                        this.trainFile = rest.substring(0);
                        break;
                    }
                    this.trainFile = null;
                    break;
                }
                case 'T': {
                    if (rest != null) {
                        this.testFile = rest.substring(0);
                        break;
                    }
                    this.testFile = null;
                    break;
                }
                case 'v': {
                    if (rest == null) break;
                    this.verbosity = Integer.parseInt(rest);
                    if (this.verbosity >= 0 && this.verbosity <= 2) break;
                    M5.errorMsg("verbosity level should range within (0-2). See -help.");
                    break;
                }
                case 'x': {
                    this.numFolds = 10;
                    if (rest == null) break;
                    this.numFolds = Integer.parseInt(rest);
                    if (this.numFolds > 1 && this.numFolds <= 100) break;
                    M5.errorMsg("fold number for cross-validation must be within (2 - 100). See -help.");
                    break;
                }
                default: {
                    if (rest == null) {
                        System.out.println("M5' error: Invalid option -" + sw);
                    } else {
                        M5.errorMsg("invalid option -" + sw + " " + rest);
                    }
                    System.exit(1);
                }
            }
            rest = null;
        }
        if (this.trainFile == null) {
            M5.errorMsg("no training file specified. See -help.");
        }
    }

    public final void initialize(M5Instances inst) throws Exception {
        Object index = null;
        if (this.numFolds > inst.numInstances()) {
            M5.errorMsg("fold number for cross-validation greater than the number of instances.");
        }
        if (this.classcol == -3 || this.classcol == -1) {
            this.classcol = inst.numAttributes() - 1;
        }
        if (inst.classAttribute().isNominal()) {
            M5.errorMsg("class column must be real or integer attribute.");
        }
        if (this.verbosity < 0 && (this.testFile == null || this.numFolds >= 1)) {
            this.verbosity = 0;
        }
    }

    public final String toString(M5Instances inst) throws Exception {
        StringBuffer text = new StringBuffer();
        text.append("    Options:\n\n");
        text.append("        Training file   :     " + this.trainFile + "\n");
        if (this.testFile != null) {
            text.append("        Test file       :     " + this.testFile + "\n");
        }
        text.append("        Class attribute :     " + inst.classAttribute().name() + " (column " + (this.classcol + 1) + ")\n");
        if (this.numFolds > 1) {
            text.append("        Cross-Validation:     " + this.numFolds + "-fold with random seed " + this.randomSeed + "\n");
        }
        text.append("        Verbosity level :     " + this.verbosity + "\n");
        if (this.model == 1) {
            text.append("        Output model    :     linear regression\n");
        }
        if (this.model == 2) {
            text.append("        Output model    :     regression tree\n");
        }
        if (this.model == 3) {
            text.append("        Pruning factor  :     " + this.pruningFactor + "\n");
            text.append("        Output model    :     model tree\n");
        }
        text.append("\n");
        return text.toString();
    }

    public final void printValidOptions() {
        System.out.println("Usage:");
        System.out.println("      M5Java [-options]\n");
        System.out.println("Options:");
        System.out.println("  -c (<num>|first|last)  column to predict values (default last)");
        System.out.println("  -f <num>               pruning factor 0.0 - 10.0 (default 1.0)");
        System.out.println("  -h                     displays this help");
        System.out.println("  -o <l|m|r>             output model: linear, model tree, or regression tree");
        System.out.println("  -s <num>               random seed for cross-validation only. No randomization");
        System.out.println("                         while 0 (default 1)");
        System.out.println("  -t <file>              training set file ");
        System.out.println("  -T <file>              test set file");
        System.out.println("  -v <num>               verbosity level 0,1,2 (default 0)");
        System.out.println("  -x <num>               cross validation (default 10-fold)\n");
        System.out.println("Definitions:");
        System.out.println("  Correlation coefficient: correlation between actual values and predictions");
        System.out.println("  Mean absolute error: average absolute prediction error");
        System.out.println("  Root mean squared error: square root of the average squared prediction error");
        System.out.println("  Relative absolute error: ratio of the mean absolute residuals to the absolute");
        System.out.println("      deviation of the target values");
        System.out.println("  Root relative squared error: square root of the ratio of the variance of the ");
        System.out.println("      residuals to the variance of the target values\n");
        System.out.println("  Note: 100% relative error is the same as would be obtained by predicting a");
        System.out.println("      simple average\n");
        System.out.println("Description:");
        System.out.println("  An unsmoothed prediction is calculated directly by the function at the leaf.");
        System.out.println("  A smoothed prediction uses the value calculated at the leaf of the tree,");
        System.out.println("  and passes it back up the tree, smoothing at each higher node.\n");
        System.out.println("  Let");
        System.out.println("\tp' be the model passed up to the next higher node,");
        System.out.println("\tp be the model passed to this node from below,");
        System.out.println("\tq be the model at this node,");
        System.out.println("\tn be the number of training instances that reach the node below,");
        System.out.println("\tk be a constant (default value 15),\n");
        System.out.println("  then the smoothed model at this node is:\n");
        System.out.println("\tp' = (n*p+k*q) / (n+k)\n");
        System.out.println("Version:");
        System.out.println("\tv1.1");
        System.exit(1);
    }
}

