/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.exprtree;

import java.util.Iterator;
import net.sourceforge.jclec.JCLEC;
import net.sourceforge.jclec.exprtree.IPrimitive;

public class ExprTree
implements JCLEC {
    private static final long serialVersionUID = -6257654283422181797L;
    private IPrimitive[] blocks = new IPrimitive[10];
    private int blockIndex = 0;
    private transient int pindex = 0;

    public void addBlock(IPrimitive block) {
        if (this.blockIndex == this.blocks.length) {
            IPrimitive[] aux = new IPrimitive[2 * this.blockIndex];
            int i = 0;
            while (i < this.blockIndex) {
                aux[i] = this.blocks[i];
                ++i;
            }
            this.blocks = aux;
        }
        this.blocks[this.blockIndex++] = block;
    }

    public IPrimitive getBlock(int blockIndex) {
        return this.blocks[blockIndex];
    }

    public void setBlock(IPrimitive block, int blockIndex) {
        this.blocks[blockIndex] = block;
    }

    public int size() {
        return this.blockIndex;
    }

    public ExprTree copy() {
        IPrimitive[] codeCopy = new IPrimitive[this.blocks.length];
        int i = 0;
        while (i < this.blockIndex) {
            codeCopy[i] = this.blocks[i].copy();
            ++i;
        }
        ExprTree result = new ExprTree();
        result.blockIndex = this.blockIndex;
        result.blocks = codeCopy;
        return result;
    }

    public int subTree(int rootIndex) {
        int resultIndex = rootIndex;
        int aux = 0;
        do {
            try {
                aux += this.blocks[resultIndex].argumentTypes().length;
                ++resultIndex;
            }
            catch (NullPointerException e) {
                System.out.println("tree=" + this.toString());
                System.out.println("blockIndex=" + rootIndex);
            }
        } while (aux-- != 0);
        return resultIndex;
    }

    public Iterator<IPrimitive> executeIterator() {
        return new ExecuteIterator();
    }

    public String toString() {
        this.pindex = 0;
        StringBuffer sb = new StringBuffer();
        this.toStringRecurse(sb);
        return sb.toString();
    }

    private void toStringRecurse(StringBuffer sb) {
        IPrimitive rootSymbol;
        int rootSons;
        if ((rootSons = (rootSymbol = this.blocks[this.pindex++]).argumentTypes().length) == 0) {
            sb.append(rootSymbol.toString());
        } else {
            sb.append("(");
            sb.append(rootSymbol.toString());
            int i = 0;
            while (i < rootSons) {
                this.toStringRecurse(sb);
                ++i;
            }
            sb.append(")");
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ExprTree) {
            ExprTree cother = (ExprTree)other;
            if (this.blockIndex == cother.blockIndex) {
                int i = 0;
                while (i < this.blockIndex) {
                    if (!this.blocks[i].equals(cother.blocks[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    class ExecuteIterator
    implements Iterator<IPrimitive> {
        private int actualIndex;

        ExecuteIterator() {
            this.actualIndex = ExprTree.this.blockIndex;
        }

        @Override
        public boolean hasNext() {
            return this.actualIndex > 0;
        }

        @Override
        public IPrimitive next() {
            return ExprTree.this.blocks[--this.actualIndex];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

