/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import org.af.commons.widgets.WidgetFactory;
import org.af.commons.widgets.buttons.HorizontalButtonPane;
import org.af.commons.widgets.buttons.OKButtonPane;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.dialogs.InfoDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AboutDialog
extends InfoDialog
implements ActionListener {
    private static Log logger = LogFactory.getLog(AboutDialog.class);
    private static final long serialVersionUID = 1L;
    JTextPane jtAbout = new JTextPane();

    public AboutDialog(JFrame parent) {
        super(parent, "About gMCP-GUI " + Configuration.getInstance().getGeneralConfig().getVersionNumber());
        this.jtAbout.setStyledDocument(this.getDocument());
        this.jtAbout.setEditable(false);
        Container cp = this.getContentPane();
        cp.add(new JScrollPane(this.jtAbout));
        cp = WidgetFactory.makeDialogPanelWithButtons((Container)cp, (HorizontalButtonPane)new OKButtonPane(), (ActionListener)this);
        this.setContentPane(cp);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private DefaultStyledDocument getDocument() {
        DefaultStyledDocument doc = new DefaultStyledDocument();
        logger.info((Object)"Creating About-Text.");
        try {
            doc.insertString(doc.getLength(), "gMCP " + Configuration.getInstance().getGeneralConfig().getVersionNumber() + "\n\n", AboutDialog.getH1());
            doc.insertString(doc.getLength(), "by Kornelius Rohmeyer and Florian Klinglmueller is distributed under GPL 2.0.\n\n", AboutDialog.getT());
            doc.insertString(doc.getLength(), "This program uses the libraries log4j, JLaTeXMath, POI, iText (2.1.4), jxlayer,\n swingworker, commons logging/lang, JRI and JGoodies Forms.\n", AboutDialog.getT());
            doc.insertString(doc.getLength(), "\nThis program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details. It is included\nin the R distribution (in directory share/licenses) or can be\nfound at: http://www.gnu.org/licenses/\n", AboutDialog.getT());
            doc.setParagraphAttributes(0, doc.getLength(), AboutDialog.getC(), true);
        }
        catch (BadLocationException ble) {
            logger.error((Object)"BadLocationException was thrown. Should never happen.", (Throwable)ble);
        }
        return doc;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            this.dispose();
        }
    }
}

