/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import org.jgrapht.Graph;
import org.jgrapht.ext.StringNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class VisioExporter<V, E> {
    private VertexNameProvider<V> vertexNameProvider;

    public VisioExporter(VertexNameProvider<V> vertexNameProvider) {
        this.vertexNameProvider = vertexNameProvider;
    }

    public VisioExporter() {
        this(new StringNameProvider());
    }

    public void export(OutputStream outputStream, Graph<V, E> graph) {
        PrintStream printStream = new PrintStream(outputStream);
        Iterator<Object> iterator = graph.vertexSet().iterator();
        while (iterator.hasNext()) {
            this.exportVertex(printStream, iterator.next());
        }
        iterator = graph.edgeSet().iterator();
        while (iterator.hasNext()) {
            this.exportEdge(printStream, iterator.next(), graph);
        }
        printStream.flush();
    }

    private void exportEdge(PrintStream printStream, E e, Graph<V, E> graph) {
        String string = this.vertexNameProvider.getVertexName(graph.getEdgeSource(e));
        String string2 = this.vertexNameProvider.getVertexName(graph.getEdgeTarget(e));
        printStream.print("Link,");
        printStream.print(string);
        printStream.print("-->");
        printStream.print(string2);
        printStream.print(",,,");
        printStream.print(string);
        printStream.print(",");
        printStream.print(string2);
        printStream.print("\n");
    }

    private void exportVertex(PrintStream printStream, V v) {
        String string = this.vertexNameProvider.getVertexName(v);
        printStream.print("Shape,");
        printStream.print(string);
        printStream.print(",,");
        printStream.print(string);
        printStream.print("\n");
    }
}

