#' Shiny App to Demonstrate Two-Sample Independent (Unpaired) Student's t-Test
#'
#' @name shiny_twosampt
#' @aliases shiny_twosampt
#' @description An interactive Shiny app to demonstrate two-sample independent (unpaired) Student's t-test.
#' @usage shiny_twosampt()
#'
#' @details The interactive Shiny app demonstrates the principles of the hypothesis testing of means
#'     in a two-sample independent (unpaired) design where the population variances are equal but unknown.
#'     The true parameter values are provided by the user.
#'     The user changes sample characteristics, distribution function and simulation features
#'     and explores the influence of these changes on the hypothesis testing using Student's t-test.
#'
#'     The left panel includes the user inputs for \strong{Simulation Features}, \strong{Population Parameters},
#'     \strong{Sample Characteristics}, and \strong{Distribution Function}.
#'     To use the app at first instance, just click the \code{Update} button.
#'     To alter the input values, edit the text box or move the point on the slider and
#'     explore the changes in different tabs (see below).
#'
#'     To obtain identical outcomes in a separate run of the app,
#'     set a common seed value at the bottom of the left panel and click \code{Update}.
#'     All subsequent updates will produce identical results provided other inputs are identical.
#'     The seed value is ignored when the option \code{check the box to update instantly} is selected.
#'
#' @return The outcomes are presented in several tabs.
#'     \item{Population}{contains the density plots of two populations and
#'     rug plots of the sample units sample units randomly drawn from these populations.
#'     It also includes the population parameter values chosen by the user.}
#'     \item{Sample}{contains the dot plots and box plots of two samples drawn
#'     randomly from the two populations and rug plots of the sample units.
#'     It also includes the mean and standard deviation of two random samples.}
#'     \item{Test Statistic}{contains the plots showing the mean difference between two groups
#'     and corresponding 95\% confidence intervals (CI).
#'     The tab also contains a panel of the distribution of the test statistic \code{t}
#'     with the observed value of the test statistic and probabilities under the given value of the Type 1 error}
#'     \item{Summary}{includes the summary of the sampled data and outcomes
#'     from the one-sample Student's t-test. Different sections are:
#'     (1) Hypothesis, highlighting the null and alternative hypothesis;
#'     (2) Sample, tabulating the full sampled data;
#'     (3) Summary Statistics, summarising the summary information of two samples;
#'     (4) Test Statistic, presenting the outputs from independent two-sample Student's t-test.
#'     (5) Confidence Interval, highlighting the mean difference and corresponding 95\% confidence intervals (CI).}
#'
#' @note \url{https://shiny.abdn.ac.uk/Stats/apps/}
#'
#' @author Mintu Nath
#'
#' @seealso Function in base R for normal distribution and t distribution including
#'          \code{\link{dnorm}}, \code{\link{pnorm}}, \code{\link{qnorm}}, \code{\link{rnorm}},
#'          \code{\link{dt}}, \code{\link{pt}}, \code{\link{qt}}, \code{\link{rt}}
#'
#' @examples
#' if(interactive()){
#'     library(ggplot2)
#'     library(shiny)
#'     library(ABACUS)
#'     # Run shiny app
#'     shiny_twosampt()
#' }
#'
#' @import shiny
#' @import ggplot2
#' @export


# Function

shiny_twosampt <- function() {

  shiny::runApp(appDir = system.file("app_twosampt", package = "ABACUS"), launch.browser = TRUE)
  Sys.setenv("shiny_twosampt" = "")

}

