% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gene.R
\name{plot_gene}
\alias{plot_gene}
\title{Plotting and exporting methylation profile for candidate genes}
\usage{
plot_gene(x, b, cases_column_1, cases_column_n, controls_column_1,
  controls_column_n)
}
\arguments{
\item{x}{The filtered and annotated 450k probes}

\item{b}{Gene name between quotation marks}

\item{cases_column_1}{The first column (column number) for cases in the filtered dataset}

\item{cases_column_n}{The last column (column number) for cases in the filtered dataset}

\item{controls_column_1}{The first column (column number) for controls in the filtered dataset}

\item{controls_column_n}{The last column (column number) for controls in the filtered dataset}
}
\description{
This function explores the DNA methylation profile for any gene. The function generates four plots: the top plots show the difference in DNA methylation between cases and controls (a bar chart of the delta beta values for all probes arranged from 5’ to 3’ positions and a plot showing the difference in mean DNA methylation between cases and controls). The bottom plots show the distribution of DNA methylation for each probe that interrogates a CpG site in the investigated gene, for cases (left) and controls (right), respectively. Also, an annotation table for the arranged probes is generated with the following columns: probe names, gene name, distance from TSS, mean methylation for cases, mean methylation for controls, delta beta values (cases minus controls), and t-test p.values.
}
\examples{
 
data(test_data)
data(nonspecific_probes)
data(annotation_file)
test_data_filtered <- filter_data(test_data)
test_data_annotated <- annotate_data(test_data_filtered)
KLHL34 <- plot_gene(test_data_annotated, 'KLHL34', 1, 2, 3, 4)

}

