% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSigMatrix.R
\name{calcAcc}
\alias{calcAcc}
\title{Calculate prediction accuracy}
\usage{
calcAcc(estimates, reference)
}
\arguments{
\item{estimates}{The estimated cell percentages}

\item{reference}{The reference cell percentages}
}
\value{
a list with a multiple sets
}
\description{
Calculate correlation coeffifients, p-Values, MAE, RMSE for deconvolution predictions
}
\examples{
estimates <- sample(c(runif(8), 0 ,0))
estimates <- 100 * estimates / sum(estimates)
reference <- sample(c(runif(7), 0 , 0, 0))
reference <- 100 * reference / sum(reference)
calcAcc(estimates, reference)

}
