#' IRESSA Pan-Asia Study (IPASS) data set
#'
#' @name ipass
#' @docType data
#' @author Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Mutua Kilai, \email{abdisalam.hassan@amoud.edu.so}
#' @keywords datasets
#' @description Argyropoulos and Unruh (2015) published reconstructed IPASS clinical trial data. Despite being reconstructed, this data set retains all of the features shown in references, as well as full access to the observations from this clinical trial.The database spans the months of March 2006 to April 2008.The study's main goal is to compare gefitinib to carboplatin/paclitaxel doublet chemotherapy as first-line treatment in terms of progression-free survival (in months) in selected non-small-cell lung cancer (NSCLC) patients.
#' @format A data frame with 1217 rows and 3 variables:
#' \itemize{
#'   \item time: progression free survival (in months)
#'   \item status: failure indicator (1 - failure; 0 - otherwise)
#'   \item arm: (1 - gefitinib; 0 - carboplatin/paclitaxel doublet chemotherapy)
#' }
#' @references  Argyropoulos, C. and Unruh, M. L. (2015). Analysis of time to event outcomes in randomized controlled trials by generalized additive models. PLOS One 10, 1-33.
#'
NULL
