% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHReg1.R
\name{AHMLE}
\alias{AHMLE}
\title{Overall Survival AH model.}
\format{
By default the function calculates the following values:
\itemize{
  \item AIC:  Akaike Information Criterion;
   \item CAIC: Consistent Akaikes Information Criterion;
    \item BIC:  Bayesian Information Criterion;
     \item BCAIC:  Bozdogan’s Consistent Akaike Information Criterion;
     \item HQIC:  Hannan-Quinn information criterion;
     \item par:  maximum likelihood estimates;
     \item Value:  value of the likelihood function;
    \item Convergence:  0 indicates successful completion and 1 indicates that the iteration limit maxit.
 }
}
\usage{
AHMLE(
  init,
  time,
  delta,
  n,
  basehaz,
  z,
  method = "Nelder-Mead",
  maxit = 1000,
  log = FALSE
)
}
\arguments{
\item{init}{: initial points for optimisation}

\item{time}{: survival times}

\item{delta}{: vital indicator (0-alive,1 - dead,)}

\item{n}{: The number of the observations of the data set}

\item{basehaz}{: {baseline hazard structure including baseline
(NGLLAH,GLLAH,EWAH,KWAH,MLLAH,PGWAH,GGAH,
MKWAH,LLAH,WAH,GAH,LNAH,BXIIAH)}}

\item{z}{: design matrix for covariates (p x n), p >= 1}

\item{method}{:"nlminb" or a method from "optim"}

\item{maxit}{:The maximum number of iterations. Defaults to 1000}

\item{log}{:log scale (TRUE or FALSE)}
}
\value{
a list containing the output of the optimisation (OPT) and the information criterion including (AIC, BIC, CAIC, BCAIC, and HQIC).
}
\description{
The flexible parametric accelerated hazards (AH) model's maximum likelihood estimation, log-likelihood, and information criterion.
Baseline hazards: NGLL, GLL,KW, EW, MLL, PGW, GG, MKW, Log-logistic, Weibull,  Log-normal, Burr-XII, and Gamma
}
\details{
The function AHMLE returns MLE estimates and information criterion.
}
\examples{
#Example #1
data(ipass)
time<-ipass$time
delta<-ipass$status
z<-ipass$arm
AHMLE(init = c(1.0,1.0,1.0,0.5),time = time,delta = delta,n=nrow(z),
basehaz = "GLLAH",z = z,method = "Nelder-Mead",
maxit = 1000)

#Example #2
data(bmt)
time<-bmt$Time
delta<-bmt$Status
z<-bmt$TRT
AHMLE(init = c(1.0,1.0,1.0,0.5),time = time,delta = delta,n=nrow(z),
basehaz = "GLLAH",z = z,method = "Nelder-Mead",
maxit = 1000)

#Example #3
data("e1684")
time<-e1684$FAILTIME
delta<-e1684$FAILCENS
TRT<-e1684$TRT
AGE<-e1684$TRT
z<-as.matrix(cbind(scale(TRT), scale(AGE) ))
AHMLE(init = c(1.0,1.0,1.0,0.5,0.75),time = time,delta = delta,n=nrow(z),
basehaz = "GLLAH",z = z,method = "Nelder-Mead",maxit = 1000)

#Example #4
data("LeukSurv")
time<-LeukSurv$time
delta<-LeukSurv$cens
age<-LeukSurv$age
wbc<-LeukSurv$wbc
tpi<-LeukSurv$tpi
z<-as.matrix(cbind(scale(age), scale(tpi),scale(wbc) ))
AHMLE(init = c(1.0,1.0,1.0,1.0,0.5,0.65,0.85),time = time,delta = delta,n=nrow(z),
basehaz = "NGLLAH",z = z,method = "Nelder-Mead",maxit = 1000)

}
\author{
Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Mutua Kilai, \email{abdisalam.hassan@amoud.edu.so}
}
