% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMCcreatetest.R
\name{AMCcreatetest}
\alias{AMCcreatetest}
\title{Create a full Auto-Multiple-Choice test with a main .tex file (\code{groups.tex}), a file for questions (\code{questions.tex}), a file for elements (\code{elements.tex}.}
\usage{
AMCcreatetest(question, correctanswers, incorrectanswers,
  element = "general", code = paste(codeprefix, c(1:length(question)),
  sep = ""), codeprefix = "Q", questiontype = "single",
  multicols = 2, scoringcorrect = 1, scoringincorrect = 0,
  scoringnoresponse = 0, scoringincoherent = scoringincorrect,
  scoringbottom = scoringincorrect, shufflequestions = T,
  shuffleanswers = T, shuffleanswersonce = T, sections = T,
  title = "Test", filepath = "source.tex", messages = T,
  fontsize = 10, instructions = T, paper = "letter",
  identifier = "Name", separateanswersheet = F,
  answersheettitle = "Answer sheet", answersheetinstructions = T,
  twosided = T, lettersinsidebox = F, box = T,
  facilitatemanualadd = T)
}
\arguments{
\item{question}{A character value or vector containing the questions.}

\item{correctanswers}{A character (value, vector) containing the correct answer. A vector (or list) of character vectors can also be passed, in the case of multiple correct answers.}

\item{incorrectanswers}{A character (value, vector) containing the wrong answer. A vector (or list) of character vectors can also be passed, in the case of multiple wrong answers.}

\item{element}{A character value or vector to define the category of the entire set of questions (character value) or of each question (character vector). Defaults to "general.}

\item{code}{A character value or vector to identify each question (note that AMC requires each code to be unique in a questionnaire). Defaults to "Q1", "Q2", "Q3", etc. (the prefix "Q" can be changed with the "codeprefix" argument).}

\item{codeprefix}{A character value to be used to generate automatically question codes, when not provided with the "code" argument.}

\item{questiontype}{A character value or vector to indicate the type of all questions (character value) or of each (character vector) question. Use "single" for single-choice, and "multiple" for multiple-answer. So far open questions are not supported.}

\item{multicols}{A numeric (or numeric vector) indicating the desired number of columns for the presentation of the correct and incorrect answers (note that the LaTeX environment multicols must be called in the main ".tex" document for more than 1 columns). Defaults to 1, which does not require the LaTeX multicols environnment.}

\item{scoringcorrect}{A numeric value or vector to indicate the scoring for the correct answer(s). Defaults to 1.}

\item{scoringincorrect}{A numeric value or vector to indicate the scoring for an incorrect answer(s). Defaults to 0.}

\item{scoringnoresponse}{A numeric value or vector to indicate the scoring for non-responding. Defaults to 0.}

\item{scoringincoherent}{A numeric value or vector to indicate the scoring for incoherent answer(s) (e.g. two boxes checked for a single-answer questionnaire). Defaults to 0.}

\item{scoringbottom}{A numeric value or vector to indicate the minimum score for the question(s). Especially useful when attributing negative points to incorrect answers in a multiple-answer questionnaire, to ensure students do not lose too many points on one question. Defaults to 0.}

\item{shufflequestions}{A logical value or vector to indicate whether to shuffle questions inside a question group. Defaults to TRUE.}

\item{shuffleanswers}{A logical value or vector to indicate whether to shuffle answers per examinee. Defaults to TRUE. If set to FALSE, it is recommended to shuffle once for all examinee with shuffle the answers once with 'shuffleanswersonce = TRUE'.}

\item{shuffleanswersonce}{A logical value to indicate whether to shuffle answers for each question directly in the LaTeX code (useful if the answers are not randomized by examinee by AMC). Defaults to TRUE.}

\item{sections}{A character value or vector to indicate whether to create a new LaTeX section for each element (defaults to TRUE).}

\item{title}{A character value indicating a title for the test (default is "Test").}

\item{filepath}{A character value indicating the path for the main .tex file output. Most often, in AMC, it is \code{source.tex} (default), but in some examples it's named \code{groups.tex}, for example. Note that the other created files (\code{questions.tex} and \code{elements.tex} will we written in the folder of this file).}

\item{messages}{A logical value to indicate whether to output messages and reports (default is TRUE).}

\item{fontsize}{A numeric value to indicate the font size of the output document. Default is 10. Note: Above 12 pt, the LaTeX package "extarticle" is automatically used in lieu of "article".}

\item{instructions}{A logical value to add a block of preliminary instructions to the students (for example, how to fill the questionnaire). Defaults to TRUE.}

\item{paper}{A character value indicating what type of paper to use. Default is "letter", but "a4" can also be used.}

\item{identifier}{A character value indicating what to ask for to pair the exam sheets. The default is "Name", but other values like "Student ID Number" may be more appropriate.}

\item{separateanswersheet}{A logical value to indicate whether to use a separate answer sheet. Defaults to FALSE.}

\item{answersheettitle}{A character value to indicate the title of the separate answer sheet. Defaults to "Answer sheet".}

\item{answersheetinstructions}{A logical or character value to add default (TRUE), remove (FALSE) or customize (character value) instructions given on the separate answer sheet. Default is TRUE, which indicates that the students shall answer on the answer sheet.}

\item{twosided}{A logical value to indicate whether the exam will be printed two sided. This is notably important when printing on a separate answer sheet, to have the answer sheet printed on a separate page. Defaults to TRUE.}

\item{lettersinsidebox}{A logical value to indicate whether to put letters inside boxes. Defaults to FALSE.}

\item{box}{A logical value to indicate whether to box the questions and answers, to ensure that they are always presented on the same page. Defaults to TRUE.}

\item{facilitatemanualadd}{A logical indicating whether to add LaTeX code to facilitate adding questions and elements manually. If TRUE, creates .tex files where questions and elements can be input manually without changing the main files. Defaults to FALSE.}
}
\value{
Writes 3 .tex documents (\code{source.tex}, \code{questions.tex} and \code{elements.tex})) for direct use in Auto-Multiple-Choice.
}
\description{
Create a full Auto-Multiple-Choice test with a main .tex file (\code{groups.tex}), a file for questions (\code{questions.tex}), a file for elements (\code{elements.tex}.
}
\examples{
# Create all LaTeX files

\dontrun{
 AMCcreatetest(
 # Arguments passed to AMCcreatequestions()
 question = "How much is $1+1$?",
 correctanswers = 2,
 incorrectanswer = list("3", "11", "4"),
 # Arguments passed to AMCcreateelements()
 shufflequestions = T,
 sections = F,
 # Part used for test options
 title = "Exam", #Custom title
 fontsize = 11, #change fontsize
 identifier = "ID Number", #change identifier
 twosided = F, #print in one sided
 instructions = T, #show an instructions block to students
 separateanswersheet = F, #use a separate answer sheet
 answersheettitle = "Respond Here", #Change answer sheet title
 answersheetinstructions = "Fill the boxes" #Answer sheet instructions
  )}

}
