% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Detergent.R
\docType{data}
\name{Detergent}
\alias{Detergent}
\title{Detergent data}
\format{
An object of class list.
}
\source{
\doi{10.20982/tqmp.19.2.p173}
}
\usage{
Detergent
}
\description{
The data, taken from \insertCite{rs63;textual}{ANOFA}, is a dataset examining
the distribution of a large sample of customers, classified over
four factors:
\verb{Softness of water used} (3 levels: soft, medium or hard),
\verb{Expressed preference for brand M or X after blind test} (2 levels:
Brand M or Brand X), \verb{Previously used brand M} (2 levels: yes
or no), and \verb{Temperature of landry water} (2 levels: hot or
cold). It is therefore a 3 × 2 × 2 × 2 design with 24 cells.
}
\examples{

# convert the data to a data.frame
dta <- data.frame(Detergent)

# run the anofa analysis
\dontrun{
w <- anofa( Freq ~  Temperature * M_User * Preference * Water_softness, dta)

# make a plot with all the factors
anofaPlot(w)

# ... or with just a few factors
anofaPlot(w, ~ Preference * M_User )
anofaPlot(w, ~ Temperature )

# extract simple effects
e <- emFrequencies(w, ~ M_User | Preference ) 
}

}
\references{
\insertAllCited{}
}
\keyword{datasets}
