% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_food_insecurity.R
\name{calc_food_insecurity}
\alias{calc_food_insecurity}
\title{Calculate Food Insecurity Risk}
\usage{
calc_food_insecurity(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `food_insecurity`, where `food_insecurity`
is TRUE if the participant reported experiencing food insecurity, and FALSE otherwise. Participants who
did not respond to both questions will have an NA value for `food_insecurity`.
}
\description{
This function creates a binary categorical variable (TRUE/FALSE) indicating whether a participant
is at risk or currently experiencing food insecurity based on their responses to two specific survey items.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = c(1, 1, 2, 2, 3, 3, 4, 4, 5, 5),
  question_concept_id = rep(c(40192426, 40192517), 5),
  answer_concept_id = c(40192508, 40192488, 40192508, 903096, 903096, 903096,
                        40192488, 40192488, 40192508, 40192508)
)

# Compute food insecurity risk scores
food_insecurity_scores <- calc_food_insecurity(survey_df)
head(food_insecurity_scores)

}
