% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_spa.R
\name{calc_spa}
\alias{calc_spa}
\title{Calculate Environmental Support for Physical Activity (SPA) Score}
\usage{
calc_spa(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `spa`, where `spa` is the sum score for environmental support for physical activity.
The score is based on responses to seven items, with higher values indicating more support for physical activity.
Participants who did not answer all seven questions will have NA values.
}
\description{
This function computes a numeric score representing the environmental support for physical activity (SPA).
The score ranges from 7 to 28, with higher scores indicating greater environmental support for physical activity.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 7),
  question_concept_id = rep(c(40192436, 40192440, 40192437, 40192431,
                              40192410, 40192492, 40192414), times = 3),
  answer_concept_id = sample(c(40192514, 40192478, 40192527, 40192422),
                             21, replace = TRUE)
)

# Compute environmental support for physical activity (SPA) scores
spa_scores <- calc_spa(survey_df)
head(spa_scores)

}
