% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolate.signal.R
\name{isolate.signal}
\alias{isolate.signal}
\alias{isolateContribution}
\title{isolateContribution}
\usage{
isolateContribution(
  data,
  pollutant,
  background = NULL,
  deseason = TRUE,
  deweather = TRUE,
  method = 2,
  add.term = NULL,
  formula = NULL,
  use.bam = FALSE,
  output = "mean",
  ...
)
}
\arguments{
\item{data}{Data source, typically \code{data.frame}
(or similar), containing all time-series to be used when
applying signal processing.}

\item{pollutant}{The column name of the \code{data}
time-series to be signal processed.}

\item{background}{(optional) if supplied, the background
time-series to use as a background correction.
See below.}

\item{deseason}{logical or character vector, if
\code{TRUE} (default), the \code{pollutant} is
deseasonalised using \code{day.hour} and \code{year.day}
frequency terms, all calculate from the \code{data}
time stamp, assumed to be \code{date} in \code{data}.
Other options: \code{FALSE} to turn off
deseasonalisation; or a character vector of frequency
terms if user-defining. See below.}

\item{deweather}{logical or character vector, if
\code{TRUE} (default), the data is deweathered using
wind speed and direction, assumed to be \code{ws}
and \code{wd} in \code{data}). Other options: \code{FALSE}
to turn off deweathering; or a character vector of
\code{data} column names if user-defining. See below.}

\item{method}{numeric, contribution isolation method
(default 2). See Note.}

\item{add.term}{extra terms to add to the contribution
isolation model; ignore for now (in development).}

\item{formula}{(optional) Signal isolate model formula;
this allows user to set the signal isolation model formula
directly, but means function arguments \code{background},
\code{deseason} and \code{deweather} will be ignored.}

\item{use.bam}{(logical) If TRUE, the \code{bam} is used instead of
standard \code{gam} to build the model.}

\item{output}{output options; currently, \code{'mean'}, \code{'model'},
and \code{'all'}; but please note these are in development and may be
subject to change.}

\item{...}{other arguments; ignore for now (in development)}
}
\value{
\code{isolateContribution} returns a vector of
predictions of the \code{pollutant} time-series after
the requested signal isolation.
}
\description{
Environmental time-series signal processing:
Contribution isolation based on background subtraction,
deseasonalisation and/or deweathering.
}
\details{
\code{isolateContribution} estimates and
subtracts \code{pollutant} variance associated with
factors that may hinder break-point/segment analysis:
\itemize{
 \item \strong{Background Correction} If applied, this fits
 the supplied \code{background} time-series as a
 spline term: \code{s(background)}.
 \item \strong{Seasonality} If applied, this fits regular
 frequency terms, e.g. \code{day.hour}, \code{year.day},
 as spline terms, default TRUE is equivalent to
 \code{s(day.hour)} and \code{s(year.day)}. All terms are
 calculated from \code{date} column in \code{data}.
 \item \strong{Weather} If applied, this fits time-series of
 identified meteorological measurements, e.g. wind speed
 and direction (\code{ws} and \code{wd} in \code{data}).
 If both \code{ws} and \code{wd} are present these are
 fitted as a tensor term \code{te(ws, wd)}. Other
 \code{deweather}ing terms, if included, are fitted
 as spline term \code{s(term)}. The default \code{TRUE}
 is equivalent to \code{te(ws, wd)}.
}
Using the supplied arguments, it builds a signal
(\code{\link[mgcv]{mgcv}}) GAM model, calculates,
and returns the mean-centred residuals as an
estimate of the isolated local contribution.
}
\note{
\code{method} was included as part of method
development and testing work, and retained for now.
Please ignore for now.
}
\examples{
#fitting a simple deseasonalisation, deweathering
#and background correction (dswb) model to no2:

aq.data$dswb.no2 <- isolateContribution(aq.data,
                        "no2", background="bg.no2")

#compare at 14 day resolution:
temp <- openair::timeAverage(aq.data, "14 day")

#without dswb
quantBreakPoints(temp, "no2", test=FALSE, h=0.1)

#with dswb
quantBreakPoints(temp, "dswb.no2", test=FALSE, h=0.1)
}
\references{
Regarding \code{\link[mgcv]{mgcv}} GAM fitting methods, see
Wood (2017) for general introduction and package
documentation regarding coding (\code{\link[mgcv]{mgcv}}):

Wood, S.N. (2017) Generalized Additive Models:
an introduction with R (2nd edition), Chapman and Hall/CRC.

Regarding \code{isolateContribution}, see:

Ropkins, K., Walker, A., Philips, I., Rushton, C., Clark, T. and
Tate, J., Change Detection of Air Quality Time-Series Using the
R Package AEQval. Available at SSRN 4267722.
https://ssrn.com/abstract=4267722 or http://dx.doi.org/10.2139/ssrn.4267722
Also at: https://karlropkins.github.io/AQEval/articles/AQEval_Intro_Preprint.pdf
}
\seealso{
Regarding seasonal terms and frequency
analysis, see also \code{\link{stl}} and
\code{\link{spectralFrequency}}.

\code{\link[mgcv]{mgcv}}, \code{\link[mgcv]{gam}}.
}
\author{
Karl Ropkins
}
