% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subpop_children.R
\name{subpop_children}
\alias{subpop_children}
\title{Simulate households with children}
\usage{
subpop_children(
  df,
  n = 5,
  prop_parent_couple = NULL,
  prop_children_couple = NULL,
  prop_children_lone = NULL,
  prop_elem_age = NULL,
  parent_dist = stats::runif,
  child_dist = stats::runif,
  age_dist = stats::runif,
  ...
)
}
\arguments{
\item{df}{simulated output data frame from elementary_pop function}

\item{n}{population multiplier, default value = 5}

\item{prop_parent_couple}{proportion of parents as a couple (optional)}

\item{prop_children_couple}{vector of proportions for coupled parents with 1, 2, 3+ children (optional)}

\item{prop_children_lone}{vector of proportions for single parents with 1, 2, 3+ children (optional)}

\item{prop_elem_age}{proportion of children that are of elementary school age (optional)}

\item{parent_dist}{distribution function for parent type, default is stats::runif}

\item{child_dist}{distribution function for number of children, default is stats::runif}

\item{age_dist}{distribution function for child age, default is stats::runif}

\item{...}{additional arguments passed to the distribution functions}
}
\value{
A data frame representing the simulated population of households with children, including:
\item{schoolID}{Assigned school ID for the household}
\item{houseID}{Unique identifier for each household}
\item{num_parent}{Number of parents in the household (1 or 2)}
\item{num_child}{Total number of children in the household}
\item{num_elem_child}{Number of elementary school-aged children in the household}
\item{catchID}{Assigned catchment ID for the household}
\item{schoolPop}{Total population of elementary school assigned for the household}
\item{xStart}{Starting X-coordindate for assigned catchment}
\item{xEnd}{End X-coordindate for assigned catchment}
\item{yStart}{Starting Y-coordindate for assigned catchment}
\item{yEnd}{End Y-coordindate for assigned catchment}
\item{schoolID}{Assigned school ID for the household}
\item{num_people}{Total number of people in the household}
}
\description{
Simulation of households with children using specified random distributions.
Number of observations is multiplied by a default value of five.
}
\details{
This function can be used interactively or with pre-specified parameters.
If proportions are not provided, the user will be prompted to enter them.
Custom distribution functions can be specified for parent type, number of children, and child age.
The total number of simulations (n * sum of school populations) is automatically passed as the first argument to each distribution function.
}
\examples{
# Simulate catchment area
catch_df <- catchment_sim(4, 5, shape = 2.5, rate = 1.3)

# Simulate elementary schools using default gamma distribution
elementary_df <- elementary_pop(catch_df, shape = 3.3, rate = 0.015)

# Simulate households with children
house_children <- subpop_children(elementary_df, n = 2,
                                  prop_parent_couple = 0.7,
                                  prop_children_couple = c(0.3, 0.5, 0.2),
                                  prop_children_lone = c(0.4, 0.4, 0.2),
                                  prop_elem_age = 0.6)

# Using custom distributions
house_children2 <- subpop_children(elementary_df, n = 3,
                                  prop_parent_couple = 0.7,
                                  prop_children_couple = c(0.3, 0.5, 0.2),
                                  prop_children_lone = c(0.4, 0.4, 0.2),
                                  prop_elem_age = 0.6,
                                  parent_dist = stats::rnorm, mean = 0.5, sd = 0.1,
                                  child_dist = stats::rbeta, shape1 = 2, shape2 = 2,
                                  age_dist = stats::runif)

}
