% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantfat2desd_function.R
\name{quant.fat2.desd}
\alias{quant.fat2.desd}
\title{Analysis: Polynomial splitting for double factorial in DIC and DBC}
\usage{
quant.fat2.desd(factors = list(f1, f2, block), response, dec = 3)
}
\arguments{
\item{factors}{Define f1 and f2 and/or block factors in list form. Please note that in the list it is necessary to write `f1`, `f2` and `block`. See example.}

\item{response}{response variable}

\item{dec}{Number of cells}
}
\value{
Returns the coefficients of the linear, quadratic and cubic models, the p-values of the t test for each coefficient (p.value.test) and the p-values for the linear, quadratic, cubic model splits and the regression deviations.
}
\description{
Splitting in polynomials for double factorial in DIC and DBC. Note that f1 must always be qualitative and f2 must always be quantitative. This function is an easier way to visualize trends for dual factor schemes with a quantitative and a qualitative factor.
}
\examples{
library(AgroR)
data(cloro)
quant.fat2.desd(factors = list(f1=cloro$f1,
f2=rep(c(1:4),e=5,2), block=cloro$bloco),
response=cloro$resp)
}
\seealso{
\link{FAT2DIC}, \link{FAT2DBC}
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}
}
\keyword{Experimental}
