% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tonetest_function.R
\name{tonetest}
\alias{tonetest}
\title{Analysis: t test to compare means with a reference value}
\usage{
tonetest(response, trat, mu = 0, alternative = "two.sided", conf.level = 0.95)
}
\arguments{
\item{response}{Numerical vector containing the response of the experiment.}

\item{trat}{Numerical or complex vector with treatments}

\item{mu}{A number indicating the true value of the mean}

\item{alternative}{A character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less"}

\item{conf.level}{confidence level of the interval.}
}
\value{
returns a list with the mean per treatment, maximum, minimum, sample standard deviation, confidence interval, t-test statistic and its p-value.
}
\description{
Sometimes the researcher wants to test whether the treatment mean is greater than/equal to or less than a reference value. For example, I want to know if the average productivity of my treatment is higher than the average productivity of a given country. For this, this function allows comparing the means with a reference value using the t test.
}
\note{
No treatment can have zero variability. Otherwise the function will result in an error.
}
\examples{
library(AgroR)
data("pomegranate")
tonetest(resp=pomegranate$WL,
trat=pomegranate$trat,
mu=2,
alternative = "greater")
}
\author{
Gabriel Danilo Shimizu, \email{gabrield.shimizu@gmail.com}
}
