% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEBrule.R
\name{CEBrule}
\alias{CEBrule}
\title{Constrained equal benefits rule}
\usage{
CEBrule(c)
}
\arguments{
\item{c}{A numeric cost vector.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{CEBrule} calculates the contribution vector selected by the CEB rule.
}
\details{
For each \eqn{c\in C^N} and each \eqn{i\in N}, the constrained equal benefits rule is defined by
\deqn{
\text{CEB}_i(c)=\text{max}\{c_i-\beta,\ 0\}
}
where \eqn{\beta>0} is chosen so that \eqn{\sum\limits^n_{i=1}\text{CEB}_i(c)=c_n}.

This rule focuses on the benefits each agent receives from not having to fully cover their own needs,
aiming to distribute them as equitably as possible, without any agent subsidizing another.

The contribution selected by the CEB rule for a problem \eqn{c \in C^N} coincides with the payoff vector assigned
by the modified nucleolus.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector
CEBrule(c)

}
\references{
Hu, C.-C., Tsay, M.-H., and Yeh, C.-H. (2012). Axiomatic and strategic justifications for the
constrained equal benefits rule in the airport problem. \emph{Games and Economic Behavior}, 75, 185-197.

Potters, J. and Sudhölter, P. (1999). Airport problems and consistent allocation rules.
\emph{Mathematical Social Sciences}, 38, 83–102.

Sudhölter, P. (1997). The modified nucleolus: Properties and axiomatizations.
\emph{International Journal of Game Theory}, 26, 146-182.

Thomson, W. (2024). Cost allocation and airport problems.
\emph{Mathematical Social Sciences}, 31(C), 17–31.
}
\seealso{
\code{\link{basicrule}}, \code{\link{weightedrule}}, \code{\link{clonesrule}}, \code{\link{hierarchicalrule}}
}
