% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allelic_series_sumstats.R
\name{ASKATSS}
\alias{ASKATSS}
\title{Allelic Series SKAT-O from Summary Statistics}
\usage{
ASKATSS(
  anno,
  beta,
  se,
  check = TRUE,
  eps = 1,
  lambda = 1,
  ld = NULL,
  maf = NULL,
  weights = c(1, 2, 3)
)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with integer values in 1 through
the number of annotation categories L.}

\item{beta}{(snps x 1) vector of effect sizes for the coding genetic variants
within a gene.}

\item{se}{(snps x 1) vector of standard errors for the effect sizes.}

\item{check}{Run input checks? Default: TRUE.}

\item{eps}{Epsilon added to the diagonal of the LD matrix if not positive
definite. Note, smaller values increase the chances of a false positive.}

\item{lambda}{Optional genomic inflation factor. Defaults to 1, which
results in no rescaling.}

\item{ld}{(snps x snps) matrix of correlations among the genetic variants.
Although ideally provided, an identity matrix is assumed if not.}

\item{maf}{(snps x 1) vector of minor allele frequencies. Although ideally
provided, defaults to the zero vector.}

\item{weights}{(L x 1) vector of annotation category weights. Note that the
number of annotation categories L is inferred from the length of \code{weights}.}
}
\value{
Numeric p-value of the allelic series SKAT-O test.
}
\description{
Allelic series sequence kernel association test from summary statistics.
}
\section{Notes}{

\itemize{
\item The SKAT test requires per-variant minor allele frequencies (MAFs) for
the purpose of up-weighting rarer variants. If unknown, \code{maf} can be
safely omitted. The only consequence is that the SKAT weights will no
longer be inversely proportional to the genotypic variance.
}
}

\examples{
# Generate data.
data <- DGP(n = 1e3)
sumstats <- CalcSumstats(data = data)

# Run allelic series SKAT test from sumstats.
# Note: the SKAT test requires MAF.
results <- ASKATSS(
  anno = sumstats$sumstats$anno,
  beta = sumstats$sumstats$beta, 
  maf = sumstats$sumstats$maf,
  se = sumstats$sumstats$se,
  ld = sumstats$ld
)
show(results)
}
