% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_duration.R
\name{element_duration}
\alias{element_duration}
\title{Calculate Individual Element Durations}
\usage{
element_duration(sequences_long, n_permutations = 1000)
}
\arguments{
\item{sequences_long}{A data frame containing sequences with start and end times for each element.}

\item{n_permutations}{An integer specifying the number of permutations to perform. Default is 1000.}
}
\value{
A data frame with the median duration, standard deviation, expected duration, effect size, and p-value for each element.
}
\description{
This function calculates the individual element durations and compares them to a shuffled distribution.
}
\examples{
# Example usage:
sequences_long <- data.frame(
  element = c("A", "B", "C", "A", "B", "C"),
  start_time = c(0, 5, 10, 15, 20, 25),
  end_time = c(5, 10, 15, 20, 25, 30)
)
result <- element_duration(sequences_long, n_permutations = 100)
print(result)
}
