% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{distance_matrix_mahalanobis}
\alias{distance_matrix_mahalanobis}
\title{Pairwise distance matrix based on the mahalanobis distance}
\usage{
distance_matrix_mahalanobis(unit)
}
\arguments{
\item{unit}{A matrix representing a multivariate time series where each
column is a univariate time series.}
}
\value{
a matrix with pairwise distances
}
\description{
Pairwise distance matrix of a multivariate time series based on the
Mahalanobis distance between two series, modified to consider the different
scales of series
}
\examples{
X=matrix( rnorm(2000), ncol=10  )
distance_matrix_mahalanobis(unit=X )
}
\seealso{
Prekopcsak, Zoltan, and Daniel Lemire. "Time Series Classification
by Class-Specific Mahalanobis Distance Measures." Advances in Data Analysis
and Classification 6, no. 3 (October 2012): 185-200. \doi{10.1007/s11634-012-0110-6}
}
