% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Band_Depth_Distance.R
\name{informative_bands}
\alias{informative_bands}
\title{indexes where a series is within a specific band}
\usage{
informative_bands(allbands, x)
}
\arguments{
\item{allbands}{a list with two elements the lowerbounds of all (n)(n-1)/2
pairs and the upperbounds of the pairwise bands.
Result of the function all_bands}

\item{x}{A vector  representing a univariate time series}
}
\value{
A vector with indices
}
\description{
Return the indicies in which the values of a series x are located within a
band b, called the informative bands.
}
\examples{
X=matrix( rnorm(200), ncol=10  )
M=all_bands(X)
informative_bands(M,X[,1] )

}
\seealso{
Band Depth Clustering for Nonstationary Time Series and
Wind Speed Behavior (2018) Tupper et al
}
