% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApacheLogProcessor.R
\name{read.multiple.apache.error.log}
\alias{read.multiple.apache.error.log}
\title{Reads multiple apache error log files and loads them to a data frame.}
\usage{
read.multiple.apache.error.log(path, prefix, verbose = TRUE, ...)
}
\arguments{
\item{path}{path to the folder that contains the error log files}

\item{prefix}{prefix for all error log files that will be loaded}

\item{verbose}{if the function prints messages during the logs processing}

\item{...}{parameters to be passed to read.apache.error.log function}
}
\value{
a data frame with the error log data
}
\description{
Reads multiple apache error log files and loads them to a data frame.
}
\examples{

path <- system.file("examples", package="ApacheLogProcessor")
path <- paste(path, "/", sep="")

#read multiple gziped logs with the prefix m_access_log_combined_
dfELog <- read.multiple.apache.error.log(path, "m_error_log_")

}
