% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractionation.R
\name{massfractionation}
\alias{massfractionation}
\title{Apply the mass fractionation correction}
\usage{
massfractionation(X, fract)
}
\arguments{
\item{X}{an object of class \code{redux}}

\item{fract}{a list with fractionation data for Ar37, Ar39 and Ar40}
}
\value{
an object of class \code{redux}
}
\description{
Applies the fractionation obtained from air shot data by
\code{\link{fractionation}} to the denominator detector in order to
correct it for the mass difference between the numerator and
denominator isotopes.
}
\examples{
data(Melbourne)
C <- calibration(Melbourne$X,"DCAL")
A <- massfractionation(C,Melbourne$fract)
plotcorr(A)
}
