% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BALLI.v0.2.R
\name{balliFit}
\alias{balliFit}
\title{balliFit}
\usage{
balliFit(y_mat, x_mat, tecVar, intVar = 2, full = T, cfault = 0,
  miter = 200, conv = 1e-06)
}
\arguments{
\item{y_mat}{numeric vector containing log-cpm values of each gene and each sample}

\item{x_mat}{design matrix with samples in row and covariable(s) to be estimated in column}

\item{tecVar}{numeric vector containing estimated technical variance of a gene of each sample}

\item{intVar}{numeric vector designating interest variable(s) which is(are) column number(s) of x_mat}

\item{full}{logical value designating full model (TRUE) or reduced model (FALSE).}

\item{cfault}{initial value of index showing whether converged (0) or not (1).}

\item{miter}{maximum number of iteration to converge.}

\item{conv}{threshold for convergence}
}
\value{
following components are estimated
\item{ll}{log-likelihoods}
\item{beta}{coefficients of interested variable(s)}
\item{alpha}{coefficients of nuisance variable(s)}
\item{BCF}{Bartlett's correction factor}
\item{cfault}{index whether converged or not}
}
\description{
Estimates likelihood and Bartlett correction factor using BALLI algorithm of each gene
}
\examples{
expr <- data.frame(t(sapply(1:1000,function(x)rnbinom(20,mu=500,size=50))))
group <- c(rep("A",10),rep("B",10))
design <- model.matrix(~group, data = expr)
dge <- DGEList(counts=expr, group=group)
dge <- calcNormFactors(dge)
tV <- tecVarEstim(dge,design)
gtv <- tV$tecVar[1,]
gdat <- data.frame(logcpm=tV$logcpm[1,],design,tecVar=gtv)
gy <- matrix(unlist(gdat[,1]),ncol=1)
gx <- matrix(unlist(gdat[,2:(ncol(gdat)-1)]),ncol=ncol(gdat)-2)
balliFit(y_mat=gy,x_mat=gx,tecVar=gtv,intVar=2,full=TRUE,cfault=0,miter=200,conv=1e-6)
}
