% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BLRPM.R
\name{BLRPM.est}
\alias{BLRPM.est}
\title{BLRPM Parameter Estimation function}
\usage{
BLRPM.est(RR,acc.vals,pars.in,O.Fun,
weights.mean,weights.var,weights.cov,weights.pz,OF,debug,
scale,method,lower,upper,use.log,maxit,ndeps,trace)
}
\arguments{
\item{RR}{\code{vector} of a precipitation time series}

\item{acc.vals}{\code{vector} of different accumulation levels at which statistics are to be calculated}

\item{pars.in}{\code{vector} specifying starting values of \code{lambda,gamma,beta,eta,mux} for optimization}

\item{O.Fun}{\code{objective function} to be used during optimization}

\item{weights.mean}{\code{value} for weight for mean value at first accumulation level}

\item{weights.var}{\code{vecotr} of weights for variances, has to have \code{length(acc.vals)}}

\item{weights.cov}{\code{vecotr} of weights for covariances, has to have \code{length(acc.vals)}}

\item{weights.pz}{\code{vecotr} of weights for probability of zero rainfall, has to have \code{length(acc.vals)}}

\item{OF}{\code{value} specifying the type of objective function. 1: quadratic, 2: quad symmetrized, 3: absolute, 4: abs symmetrized
Note: quadratic symmetrized proofed to be most effective and fastest}

\item{debug}{set \code{TRUE} if debugging is wished, default \code{FALSE}. Creates a log file in working directory}

\item{scale}{\code{value} specifying the scaling between gamma and eta in the objective function}

\item{method}{\code{character} defining the method to be used in \code{optim}, preferences are: "Nelder-Mead", "BFGS", "L-BFGS-B"e}

\item{lower}{\code{vector} specifying the lower boundary of parameters for "L-BFGS-B" method}

\item{upper}{\code{vector} specifying the upper boundary of parameters for "L-BFGS-B" method}

\item{use.log}{\code{logical}, set \code{TRUE} if logarithmic parameters during optimization should be used. Advantage: zero as lower boundary for parameters}

\item{maxit}{\code{value} specifying the maximum number of itereations durion optimization}

\item{ndeps}{\code{vector} specifying the change for each parameter during one interation step}

\item{trace}{\code{value} specifying output information of \code{optim}}
}
\value{
$est returns \code{vector} of estimated parameters \code{lambda,gamma,beta,eta,mux}

$conv returns \code{value} of convergence of optimization, see \code{optim} for details

$mess returns \code{character} message about optimization if using "L-BFGS-B" method

$Z returns \code{value} of objective function for estimated parameters
}
\description{
\code{BLRPM.est} estimates the five Bartlett-Lewis rectangular pulse model parameters \code{lambda,gamma,beta,eta,mux}
for a given time series \code{data}. At first the time series statistics at given accumulation levels \code{acc.vals}
are calculated. These statistics are given over to the parameter estimation algorithm together with 
parameter starting values \code{par}. An objective function \code{O.Fun} can be specified, default is \code{BLRPM.OF}.
In addition the weights for different statistics and accumulation levels \code{weights.mean, weights.var, weights.cov, weights.pz}
can be specified. For the BLRPM objective function the user can select the measure of distance between observation
and model with \code{OF}: =1 quadratic, =2: quad extended, =3: absolute, =4: abs extended.
A \code{scale} parameter controls different cases in the objective function for differences in the scale of duration
parameters gamma and eta.   
If a debugging is wished, \code{debug} can be set to \code{TRUE} and a log file is created in working directory.
Several \code{optim} parameters can be also defined. For specifics see \code{?optim}.
}
\examples{
t.sim=240

lambda <- 4/240
gamma <- 1/10
beta <- 0.3
eta <- 2
mux <- 4

pars <- c(lambda,gamma,beta,eta,mux)

sim <- BLRPM.sim(lambda,gamma,beta,eta,mux,t.sim)
est <- BLRPM.est(sim$RR,pars.in=pars,method="BFGS",use.log=TRUE)

}
\author{
Christoph Ritschel \email{christoph.ritschel@met.fu-berlin.de}
}

