% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcondYXAcens2.R
\name{fcondYXAcens2}
\alias{fcondYXAcens2}
\title{Conditional posterior distribution of the latents Y in the censoring case}
\usage{
fcondYXAcens2(xleft, xright, censor_code_filters, distr, Tau, J, sigma)
}
\description{
This function simulates form the conditional posterior distribution of the
latents Y.
}
\details{
For internal use
}
\examples{

## The function is currently defined as
function(xleft, xright, censor_code_filters, distr, Tau, J,
         sigma) {
  K <- matrix(NA, nrow = length(Tau), ncol = length(xleft))
  for (i in seq(Tau)) {
    K[i, ] <- dkcens2(
      xleft = xleft, xright = xright, c_code_filters = censor_code_filters,
      distr = distr, mu = Tau[i], sigma = sigma
    ) * J[i]
  }
  pK <- prop.table(K, margin = 2)
  y <- apply(pK, 2, function(x) sample(Tau, size = 1, prob = x))
  return(y)
}
}
\keyword{internal}
