% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BackwardSelectionBivCop.R
\name{backward_selection_BivCop}
\alias{backward_selection_BivCop}
\title{Backward Selection for Bivariate Copula Survival Models}
\usage{
backward_selection_BivCop(
  data,
  lowerBt1 = "t11",
  lowerBt2 = "t21",
  upperBt1 = "t12",
  upperBt2 = "t22",
  copula = "N",
  margins = c("PH", "PH"),
  measure = "AIC",
  cens1,
  cens2
)
}
\arguments{
\item{data}{A data frame containing the dataset.}

\item{lowerBt1}{Character. Name of the lower bound for the first time to event.}

\item{lowerBt2}{Character. Name of the lower bound for the second time to event.}

\item{upperBt1}{Character. Name of the upper bound for the first time to event.}

\item{upperBt2}{Character. Name of the upper bound for the second time to event.}

\item{copula}{Character. Type of copula to be used in the model. Default is 'N' (Normal copula).}

\item{margins}{Character vector. Margins to be used in the copula model. Default is c('PH', 'PH').}

\item{measure}{Character. Measure to be minimized during the selection process. Either 'AIC' or 'BIC'. Default is 'AIC'.}

\item{cens1}{Censoring indicator for the first time to event.}

\item{cens2}{Censoring indicator for the second time to event.}
}
\value{
A list containing:
\itemize{
\item \code{Results}: A data frame with the steps, models, and the corresponding AIC/BIC values.
\item \code{Equations}: A list with the final model equations for the selected variables.
}
}
\description{
This function performs backward selection based on AIC or BIC measures for bivariate copula survival models.
It iteratively removes variables from the model to minimize the specified measure, either AIC or BIC.
}
\examples{
\donttest{

###############################################
# Example based on AREDS dataset
# This analysis serves solely as a
# demonstration of the function's capabilities.
###############################################
data(AREDS)
subsetAREDS <- AREDS[, c('t11', 't12', 't21', 't22', 'SevScale1E',
                         'SevScale2E', 'cens1', 'cens2', 'cens')]
results <- backward_selection_BivCop(data = subsetAREDS, lowerBt1 = 't11', lowerBt2 = 't21',
                                     upperBt1 = 't12', upperBt2 = 't22',
                                     copula = 'N', margins = c('PH', 'PH'),
                                     measure = 'AIC', cens1 = AREDS$cens1,
                                     cens2 = AREDS$cens2)
print(results)
}

}
