% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Gpa}
\alias{Gpa}
\title{High school GPA versus college GPA}
\format{
A data frame/tibble with 10 observations on two variables
\describe{ 
\item{hsgpa}{high school gpa} 
\item{collgpa}{college gpa} 
}
}
\usage{
Gpa
}
\description{
Data for Example 2.13
}
\examples{

plot(collgpa ~ hsgpa, data = Gpa)
mod <- lm(collgpa ~ hsgpa, data = Gpa)
abline(mod)               # add line
yhat <- predict(mod)      # fitted values
e <- resid(mod)           # residuals
cbind(Gpa, yhat, e)       # Table 2.1
cor(Gpa$hsgpa, Gpa$collgpa)

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Gpa, aes(x = hsgpa, y = collgpa)) + 
           geom_point() + 
           geom_smooth(method = "lm") + 
           theme_bw()
}


}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
