% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrid_scheme.R
\name{gammaKernelBSS}
\alias{gammaKernelBSS}
\title{Simulation of gamma kernel Brownian semistationary processes}
\usage{
gammaKernelBSS(
  N,
  n,
  T,
  kappa = 3,
  alpha,
  lambda,
  sigma = rep(1, N + n * T + 1)
)
}
\arguments{
\item{N}{positive integer determining the number of terms in the Riemman sum element of the
hybrid scheme calculation. Should be of order at least \code{n}.}

\item{n}{positive integer indicating the number of observations per unit of time. It represents the fineness or frequency of observations.}

\item{T}{the time interval to simulate the BSS process over.}

\item{kappa}{positive integer giving the number of terms to use in the 'lower' sum of the hybrid scheme. Default set to 3.}

\item{alpha}{the smoothness parameter of the BSS process to simulate.}

\item{lambda}{the exponent parameter of the BSS process to simulate.}

\item{sigma}{the volatility process used in the BSS simulation. This should be a vector of length \code{N + n*T + 1}
representing the sample path of sigma from -N to nT. By default this is set to by a vector of 1s so that the
Gaussian core is simulated.}
}
\value{
The function returns a list of three objects, \code{core} gives the Gaussian core of the process
between 0 and T, at intervals of 1/n. \code{bss} gives the BSS sample path on the between 0 and T, at intervals of 1/n,
and \code{vol} gives the volatilty process over the same time period.

N <- 10000
n <- 100
T <- 1.0
theta <- 0.5
beta <- 0.125

kappa <- 3
alpha <- -0.2
lambda <- 1.0


vol <- exponentiatedOrnsteinUhlenbeck(N, n, T, theta, beta)
bss_simulation <- gammaKernelBSS(N, n, T, kappa, alpha, lambda, sigma = vol)
}
\description{
\code{gammaKernelBSS} uses the Hybrid scheme to simulate a Brownian semistationary process from the
gamma kernel. It simulates a path where the volatility process is independent of the driving Brownian motion of the
BSS process.
}
