% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BTdecayLassoC.R
\name{BTdecayLassoC}
\alias{BTdecayLassoC}
\title{Bradley-Terry Model with Exponential Decayed weighted likelihood and weighted Lasso with AIC or BIC criteria}
\usage{
BTdecayLassoC(
  dataframe,
  ability,
  weight = NULL,
  criteria = "AIC",
  type = "HYBRID",
  model = NULL,
  decay.rate = 0,
  fixed = 1,
  thersh = 1e-05,
  iter = 100,
  max = 100
)
}
\arguments{
\item{dataframe}{Generated using \code{\link{BTdataframe}} given raw data.}

\item{ability}{A column vector of teams ability, the last row is the home parameter.
The row number is consistent with the team's index shown in dataframe. It can be generated using \code{\link{BTdataframe}} given raw data.}

\item{weight}{Weight for Lasso penalty on different abilities}

\item{criteria}{"AIC" or "BIC"}

\item{type}{"HYBRID" or "LASSO"}

\item{model}{An Lasso path object with class wlasso or swlasso. If NULL, the whole lasso path will be run.}

\item{decay.rate}{The exponential decay rate. Usually ranging from (0, 0.01), A larger decay rate weights more
importance to most recent matches and the estimated parameters reflect more on recent behaviour.}

\item{fixed}{A teams index whose ability will be fixed as 0. The worstTeam's index
can be generated using \code{\link{BTdataframe}} given raw data.}

\item{thersh}{Threshold for convergence}

\item{iter}{Number of iterations used in L-BFGS-B algorithm.}

\item{max}{Maximum weight for \eqn{w_{ij}} (weight used for Adaptive Lasso)}
}
\value{
\item{Score}{Lowest AIC or BIC score}
\item{Optimal.degree}{The degree of freedom where lowest AIC or BIC score is achieved}
\item{Optimal.ability}{The ability where lowest AIC or BIC score is achieved}
\item{ability}{Matrix contains all abilities computed in this algorithm}
\item{Optimal.lambda}{The lambda where lowest score is attained}
\item{Optimal.penalty}{The penalty (1- s/\eqn{\max(s)}) where lowest score is attained}
\item{type}{Type of model selection method}
\item{decay.rate}{Decay rate of this model}
}
\description{
Model selection via AIC or BIC criteria. For Lasso estimators, the degree of freedom is the number of distinct groups of estimated abilities.
}
\details{
This function is usually run after the run of whole Lasso path. "model" parameter is obtained by whole
Lasso pass's run using \code{\link{BTdecayLasso}}. If no model is provided, this function will run Lasso path first (time-consuming).

Users can select the information score added to HYBRID Lasso's likelihood or original Lasso's likelihood. ("HYBRID" is recommended)

summary() function can be applied to view the outputs.
}
\references{
Masarotto, G. and Varin, C.(2012) The Ranking Lasso and its Application to Sport Tournaments. 
*The Annals of Applied Statistics* **6** 1949--1970.

Zou, H. (2006) The adaptive lasso and its oracle properties. 
*J.Amer.Statist.Assoc* **101** 1418--1429.
}
\seealso{
\code{\link{BTdataframe}} for dataframe initialization, 
\code{\link{BTdecayLasso}} for obtaining a whole Lasso path
}
