% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/71_rmse.R
\name{rmse.bvar}
\alias{rmse.bvar}
\alias{lps.bvar}
\alias{rmse}
\alias{rmse.default}
\alias{lps}
\alias{lps.default}
\title{Model fit in- and out-of-sample}
\usage{
\method{rmse}{bvar}(x, holdout, ...)

\method{lps}{bvar}(x, holdout, n_thin = 1L, ...)

rmse(x, ...)

\method{rmse}{default}(x, ...)

lps(x, ...)

\method{lps}{default}(x, ...)
}
\arguments{
\item{x}{A \code{bvar} object, obtained from \code{\link{bvar}}.}

\item{holdout}{Optional numeric matrix or dataframe. Used for the
out-of-sample fit.}

\item{...}{Not used.}

\item{n_thin}{Integer scalar. Every \emph{n_thin}'th draw in \emph{x} is used
to calculate, others are dropped.}
}
\value{
Returns a matrix with measures of model fit.
}
\description{
Functions to compute the root mean squared error and log predictive scores.
}
\examples{
\donttest{
# Access a subset of the fred_qd dataset
data <- fred_qd[, c("CPIAUCSL", "UNRATE", "FEDFUNDS")]
# Transform it to be stationary
data <- fred_transform(data, codes = c(5, 5, 1), lag = 4)

# Estimate a BVAR using one lag, default settings and very few draws
x <- bvar(data[seq(1, nrow(data) - 5), ], lags = 1,
  n_draw = 600L, n_burn = 100L, verbose = FALSE)

# Compute RMSE
rmse(x)
lps(x, holdout = data[seq(nrow(data) - 4, nrow(data)), ])
}
}
\keyword{BVAR}
\keyword{LPS}
\keyword{RMSE}
