% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TDR2.R
\name{TDR2}
\alias{TDR2}
\title{TDR2 Species Membership Value}
\usage{
TDR2(oneSpe, que, boot, boot2)
}
\arguments{
\item{oneSpe}{object of class "DNAbin" which contains DNA sequences from one species}

\item{que}{object of class "DNAbin" which contains DNA sequences different samples}

\item{boot}{a numeric value indicating times of resampling along sequence columns}

\item{boot2}{a numeric value indicating times of resampling along sequence rows (different samples)}
}
\value{
a numeric vector represents TDR values for each query against the species
}
\description{
To calculate TDR value for a set of queries and one potential species. Its value is in the range of [0,1],
0 indicates extremly weak species membership, values close 1 indicating strong species membership.
}
\note{
oneSpe and que should be the same in sequence length, i.e., they should be aligned in prior.
It's strongly recommended that oneSpe should have large enough sample size,e.g., 20.
}
\examples{

data(TibetanMoth)  
sampleSpeNames<-NAMES(TibetanMoth)
Spp<-gsub(".+,","",sampleSpeNames)
oneSpe<-TibetanMoth[grep("Macdunnoughia_crassisigna", Spp, value = FALSE,fixed = TRUE),] 
oneSpe<-as.DNAbin(as.character(oneSpe[1:5,]))
que<-TibetanMoth[grep("Agrotis_justa", Spp, value = FALSE,fixed = TRUE),] 
que2<-oneSpe[1:2,]
out<-TDR2(oneSpe,que, boot=10,boot2=10) ### true false identification
}
\references{
Jin Q, L,J.He, A.B. Zhang* (2012). A Simple 2D Non-Parametric Resampling Statistical Approach to 
Assess Confidence in Species Identification in DNA Barcoding-An Alternative to Likelihood and Bayesian Approaches.
PLoS ONE 7(12): e50831. doi:10.1371/ journal. pone. 0050831. http://dx.plos.org/ 10.1371/ journal. pone. 0050831.
}
\author{
Ai-bing ZHANG, PhD. CNU, Beijing, CHINA, contact at zhangab2008(at)mail.cnu.edu.cn
}
\keyword{TDR2}
