% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postmk.R
\name{postmk}
\alias{postmk}
\title{Marginal probability of m1,m2,m3,...,mk+1}
\usage{
postmk(w, M, Y, K, cluster, sigma2, clusteri)
}
\arguments{
\item{w}{A scalar representing the minimum number of points in each interval between two change points}

\item{M}{A scalar representing the number of points available for each data sequence}

\item{Y}{A matrix M x N with the data sequences}

\item{K}{A vector containing the number of change points for each cluster (or its initial values)}

\item{cluster}{A vector containing the cluster assignments for the data sequences (or its initial values)}

\item{sigma2}{A vector with the variances of the data sequences (or its initial values)}

\item{clusteri}{A scalar with the index of a cluster}
}
\value{
A numerical vector of size k + 1 with the sampled number of observations (or bin size, mk) between each change point for a given cluster
}
\description{
Marginal probability of m1,m2,m3,...,mk+1
}
\note{
This function is called within the Gibbs sampler, but it can also be called separately.
}
\examples{
data(data)
postmk(w = 10, M = 50, Y = data, K = c(1, 1), cluster = c(2,1,1,1,1), sigma2 = apply(data, 2, var),
clusteri = 1)

}
