% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.EV.R
\name{plot.EV}
\alias{plot.EV}
\title{Plot of posterior probabilities for each hypothesis}
\usage{
\method{plot}{EV}(x, leg.loc = "topleft", lty = 1, ...)
}
\arguments{
\item{x}{An object of the class \code{EV} created by the \code{ev.combo()}
function.}

\item{leg.loc}{Location of the legend; default is top left. See the
\code{legend()} help pages for all the options.}

\item{lty}{An vector of integers that specifies the line types. See the
\code{matplot()} function for details.}

\item{...}{Other options passed to \code{matplot()}.}
}
\value{
Plot of posterior probabilities for each hypothesis.
}
\description{
Shows how the posterior probabilities evolve as each study is
added to the analysis.
}
\details{
Each line in the graph is a hypothesis and the lines start at the
prior hypothesis probabilities (usually 1/3).
}
\examples{
x <- ev.combo(beta = c(0.0126, 5.0052, 1.2976, 0.0005),
       se.beta = c(0.050, 2.581, 2.054, 0.003) )
plot(x)
}
\seealso{
\code{\link{ev.combo}}
}

