% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{prior_predictive}
\alias{prior_predictive}
\title{Sample from the prior predictive of a Bayesian Neural Network}
\usage{
prior_predictive(bnn, n = 1)
}
\arguments{
\item{bnn}{BNN obtained using \code{\link{BNN}}}

\item{n}{Number of samples}
}
\value{
matrix of prior predictive samples; Columns are the different samples
}
\description{
Sample from the prior predictive of a Bayesian Neural Network
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  pp <- prior_predictive(bnn, n = 10)
}

}
