% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_model_fit.R
\name{model_fit_loop}
\alias{model_fit_loop}
\title{Repeated fitting Bayesian Hierarchical Models for a sequence of values of the looping variable.}
\usage{
model_fit_loop(
  loop_holder = "LOOP",
  loop_values,
  prior_func = function(x) {
     1
 },
  parallel = FALSE,
  cores = (parallel::detectCores() - 1),
  ...
)
}
\arguments{
\item{loop_holder}{A string specifying the name of the variable to loop over. The default value is `LOOP`.}

\item{loop_values}{A numeric vector containing the values to loop over for the specified variable.}

\item{prior_func}{A function that takes the specified loop_values and returns the values of the prior for the loop variable.
By default, it is a uniform prior which returns a constant value, indicating equal probability for all values.}

\item{parallel}{Logical, indicating whether or not to run the model fitting in parallel (default is FALSE).}

\item{cores}{The number of cores to use for parallel execution (default is detected cores - 1).}

\item{...}{Additional arguments passed to the model fitting function `model_fit`.}
}
\value{
A data frame containing the values of the looping variable, their corresponding log marginal likelihoods,
and posterior probabilities.
}
\description{
Performs repeated model fitting over a sequence of values for a specified variable within a hierarchical model.
This function repeatedly fits a model for each value of the looping variable, compiles the log marginal likelihoods,
and calculates the posterior probabilities for the variable's values.
}
