% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_post_fit.R
\name{predict.FitResult}
\alias{predict.FitResult}
\title{To predict the GP component in the fitted model, at the locations specified in `newdata`.}
\usage{
\method{predict}{FitResult}(
  object,
  newdata = NULL,
  variable,
  deriv = 0,
  include.intercept = TRUE,
  only.samples = FALSE,
  quantiles = c(0.025, 0.5, 0.975),
  boundary.condition = "Yes",
  ...
)
}
\arguments{
\item{object}{The fitted object from the function `model_fit`.}

\item{newdata}{The dataset that contains the locations to be predicted for the specified GP. Its column names must include `variable`.}

\item{variable}{The name of the variable to be predicted, should be in the `newdata`.}

\item{deriv}{The degree of derivative that the user specifies for inference. Only applicable for a GP in the `iwp` type.}

\item{include.intercept}{A logical variable specifying whether the intercept should be accounted when doing the prediction. The default is TRUE. For Coxph model, this 
variable will be forced to FALSE.}

\item{only.samples}{A logical variable indicating whether only the posterior samples are required. The default is FALSE, and the summary of posterior samples will be reported.}

\item{quantiles}{A numeric vector of quantiles that predict.FitResult will produce, the default is c(0.025, 0.5, 0.975).}

\item{boundary.condition}{A string specifies whether the boundary.condition should be considered in the prediction, should be one of c("yes", "no", "only"). The default option is "Yes".}

\item{...}{Other arguments to be passed to the function.}
}
\value{
A data.frame that contains the posterior mean and pointwise intervals (or posterior samples) at the locations specified in `newdata`.
}
\description{
To predict the GP component in the fitted model, at the locations specified in `newdata`.
}
