#' Sample mortality data stratified by cause of death
#'
#' UK causes of deaths data from the Human Mortality Database
#'
#' @docType data
#' @usage data("uk_deathscausedata")
#' @format A data.frame with 1600 rows and 5 columns  (col 1: Age, col 2: Year, col 3: Deaths, col 4: Exposures, col 5: Cause)/
#' \describe{
#'   \item{Ages}{Numeric, ranging between 15 and 90.}
#'   \item{Years}{Numeric. Years at claims, spanning years 2001-2020.}
#'   \item{Deaths}{Numeric.}
#'   \item{Exposures}{Numeric.}
#'   \item{Cause}{Character. cause of deaths as coded on the HMD}
#' }
#' @keywords datasets
#' @rdname uk_deathscausedata
#' @examples
#' ##Load death data
#' data("uk_deathscausedata")
#' str(uk_deathscausedata)
#' head(uk_deathscausedata)
#' 
"uk_deathscausedata"