% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ext_array_sex.R, R/dxt_array_sex.R
\docType{data}
\name{Ext_array_sex}
\alias{Ext_array_sex}
\alias{dxt_array_sex}
\title{Sample mortality data stratified by gender/sex in the UK}
\format{
An object of class \code{array} of dimension 2 x 111 x 181.

A 3-dimensional data array (dim 1: strata, dim 2: ages, dim 3: years) with 2 strata (males and females), 111 ages, and 181 years:
\describe{
\item{Strata}{Character. Indicate the gender/sex, labelled as: \cr
\code{"Male"}: ; \cr
\code{"Female"}: ..}
\item{Ages}{Numeric. Ages at deaths, ranging between 0-109, and 110+.}
\item{Years}{Numeric. Years at deaths, spanning years 1841-2021.}
}
}
\usage{
data("Ext_array_sex")

data("dxt_array_sex")
}
\description{
This is a sample data set used for demonstration purposes. They consist of two 3-dimensional arrays, one for number of deaths (\code{dxt_array_sex}) and another for the the corresponding central exposures to risk (\code{Ext_array_sex}).
}
\examples{
##Load exposure data
data("Ext_array_sex")
str(Ext_array_sex)
head(Ext_array_sex)

#extracting a subset of the data (2 genders, ages 0-100, years 1961-2000)
Ext_array_sex[c("Male","Female"),as.character(0:100),as.character(1961:2000)]

##Load death data
data("dxt_array_sex")
str(dxt_array_sex)
head(dxt_array_sex)

#extracting a subset of the data (2 genders, ages 0-100, years 1961-2000)
dxt_array_sex[c("Male","Female"),as.character(0:100),as.character(1961:2000)]

}
\keyword{datasets}
