% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssdBF01.R
\name{porsBF01}
\alias{porsBF01}
\title{Probability of replication success based on Bayes factor}
\usage{
porsBF01(level, dprior, sr, priormean = 0, priorvar = 1)
}
\arguments{
\item{level}{Bayes factor level below which replication success is achieved}

\item{dprior}{Design prior object}

\item{sr}{Replication standard error}

\item{priormean}{Mean of the normal prior under the alternative. Defaults to
\code{0}}

\item{priorvar}{Variance of the normal prior under the alternative. Defaults
to \code{1}}
}
\value{
The probability to achieve replication success
}
\description{
This function computes the probability to achieve replication
    success based on a Bayes factor. The Bayes factor is oriented so that
    values above one indicate evidence for the null hypothesis of the effect
    size being zero, whereas values below one indicate evidence for the
    hypothesis of the effect size being non-zero (with normal prior assigned
    to it).
}
\examples{
## specify design prior
to1 <- 2
so1 <- 0.05
dprior <- designPrior(to = to1, so = so1, tau = 0.03)
porsBF01(level = 1/10, dprior = dprior, sr = c(0.05, 0.04))

}
\references{
Pawel, S., Consonni, G., and Held, L. (2022). Bayesian approaches to
designing replication studies. arXiv preprint.
\doi{10.48550/arXiv.2211.02552}
}
\author{
Samuel Pawel
}
