% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_blobs.R
\name{identify_thresholded_objects}
\alias{identify_thresholded_objects}
\title{Assign all neighboring pixels the same group number.}
\usage{
identify_thresholded_objects(img, pixRange = 50)
}
\arguments{
\item{img}{A thresholded matrix (where non-object pixels are assigned a
value of 0).}

\item{pixRange}{This parameter is now obsolete. Previously, the parameter
denoted an integer number of pixels to specify a search region. Execution
was faster when this value was small. However, the value needed to be larger
than the diameter of the largest continuous object in the image.}
}
\description{
This function is deprecated. It now calls the more efficient find_blobs
method.

This function takes a matrix corresponding to a thresholded image and
returns a matrix of the same size, where all adjacent, thresholded pixels
are the same integer corresponding to that object's cluster number.
}
\examples{
# Generate a random matrix.
set.seed(10)
mat <- matrix(runif(70), nrow = 7)

# Arbitrarily say that everything below 0.8 is background.
mat[mat < 0.8] <- 0

# Find blobs.
identify_thresholded_objects(mat)

}
\author{
Zach Colburn
}
