% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableImportance.R
\name{VariableImportance}
\alias{VariableImportance}
\title{Computes Exact or Approximate L0-penalization based Variable Importance for GLMs}
\usage{
VariableImportance(
  object,
  VIMethod = "simultaneous",
  parallel = FALSE,
  nthreads = 8,
  showprogress = TRUE
)
}
\arguments{
\item{object}{an object of class \code{BranchGLMVS}.}

\item{VIMethod}{one of "separate" or "simultaneous" to denote the method used to find
the variable importance values. This is ignored if the type of variable selection
employed in \code{object} was a heuristic method.}

\item{parallel}{a logical value to indicate if parallelization should be used.}

\item{nthreads}{number of threads used with OpenMP, only used if \code{parallel = TRUE}.}

\item{showprogress}{a logical value to indicate whether or not to show progress updates.}
}
\value{
A \code{BranchGLMVI} object which is a list with the following components
\item{\code{results}}{ a data.frame with the variable importance values and degrees of freedom}
\item{\code{metric}}{ metric used to select the best models}
\item{\code{numchecked}}{ number of models fit}
\item{\code{VS}}{ the supplied \code{BranchGLMVS} object}
\item{\code{with}}{ a numeric matrix with the best models that include each set of variables}
\item{\code{withmetrics}}{ a numeric vector with the metric values for the best models with each set of variables}
\item{\code{without}}{ a numeric matrix with the best models that exclude each set of variables}
\item{\code{withoutmetrics}}{ a numeric vector with the metric values for the best models without each set of variables}
}
\description{
Gets exact or approximate L0-penalization based variable importance values for generalized linear
models (GLMs). More details about what the variable importance values are can
be found in the details section.
}
\details{
Note that variable importance values can only be found for sets of variables that are not kept
through the model selection process. More details about the variable importance
values will be made available in an upcoming paper.

When a branch and bound algorithm is used in \code{object}, then the exact variable
importance values are computed. When a heuristic method is used, then approximate
variable importance values are computed based on the specified heuristic method.
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", 
showprogress = FALSE)

# Getting variable importance
VI <- VariableImportance(VS, showprogress = FALSE)
VI

# Plotting variable importance
oldmar <- par("mar")
par(mar = c(4, 6, 3, 1) + 0.1)
barplot(VI)
par(mar = oldmar)

}
\references{
Seedorff J, Cavanaugh JE. \emph{Assessing Variable Importance for Best
Subset Selection. Entropy. 2024; 26(9):801}. \doi{https://doi.org/10.3390/e26090801}
}
\seealso{
\link{VariableImportance.boot}, \link{barplot.BranchGLMVI}
}
