% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/districts.R
\name{districts}
\alias{districts}
\alias{districts_25N}
\alias{districts_26N}
\title{Azorean districts}
\usage{
districts(crs = laea_azores_proj())

districts_25N()

districts_26N()
}
\arguments{
\item{crs}{Coordinate reference system (CRS) passed on to
\link[sf:st_transform]{st_transform()}. Defaults to a custom CRS centered on
the Azores, see \code{\link[=laea_azores_proj]{laea_azores_proj()}} for more details. Other possible
options are \code{"EPSG: 3035"} for ETRS89-extended / LAEA Europe or
\code{"EPSG:4326"} for WGS 84.}
}
\value{
A simple features (\link[sf:sf]{sf}) object with six fields:

\describe{
\item{\code{id}}{An unique identifier for the district. Follows the format
\verb{[DT][MN][FR]}: DT is a two-digit id for the district, MN for the
municipality and FR for the district (freguesia in Portuguese).}
\item{\code{district}}{Name of the civil district.}
\item{\code{municipality}}{Name of municipality.}
\item{\code{district}}{Name of district, coincides with the name of the island.}
\item{\code{area}}{District area in hectares (ha).}
\item{\code{perimeter}}{District perimeter in kilometers.}
\item{\code{n_municipalities}}{Number of municipalities in the district.}
\item{\code{n_parishes}}{Number of parishes in the district.}
}
}
\description{
\code{\link[=districts]{districts()}} returns the boundaries of districts (islands) in the Azores.

\code{\link[=districts_25N]{districts_25N()}} returns the districts in the meter-based projection PTRA08
/ UTM zone 25N, i.e. those districts in the western-most part of the
archipelago: \emph{Ilha das Flores} and \emph{Ilha do Corvo}.

\code{\link[=districts_26N]{districts_26N()}} returns the districts in the meter-based projection PTRA08
/ UTM zone 26N, i.e. those districts in the Central and Eastern groups of
the archipelago.
}
\examples{
districts()
districts_25N()
districts_26N()

}
