% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parishes.R
\name{parishes}
\alias{parishes}
\alias{parishes_25N}
\alias{parishes_26N}
\title{Azorean civil administrative parishes}
\usage{
parishes(crs = laea_azores_proj())

parishes_25N()

parishes_26N()
}
\arguments{
\item{crs}{Coordinate reference system (CRS) passed on to
\link[sf:st_transform]{st_transform()}. Defaults to a custom CRS centered on
the Azores, see \code{\link[=laea_azores_proj]{laea_azores_proj()}} for more details. Other possible
options are \code{"EPSG: 3035"} for ETRS89-extended / LAEA Europe or
\code{"EPSG:4326"} for WGS 84.}
}
\value{
A simple features (\link[sf:sf]{sf}) object with six fields:

\describe{
\item{\code{id}}{An unique identifier for the parish. Follows the format
\verb{[DT][MN][FR]}: DT is a two-digit id for the district, MN for the
municipality and FR for the parish (freguesia in Portuguese).}
\item{\code{parish}}{Name of the civil parish.}
\item{\code{municipality}}{Name of municipality.}
\item{\code{district}}{Name of district, coincides with the name of the island.}
\item{\code{area}}{Parish area in hectares (ha).}
\item{\code{perimeter}}{Parish perimeter in kilometers.}
}
}
\description{
\code{\link[=parishes]{parishes()}} returns the boundaries of civil parishes in the Azores.

\code{\link[=parishes_25N]{parishes_25N()}} returns the parishes in the meter-based projection PTRA08 /
UTM zone 25N, i.e. those parishes in the western-most part of the
archipelago: \emph{Ilha das Flores} and \emph{Ilha do Corvo}.

\code{\link[=parishes_26N]{parishes_26N()}} returns the parishes in the meter-based projection PTRA08 /
UTM zone 26N, i.e. those parishes in the Central and Eastern groups of the
archipelago.
}
\examples{
parishes()
parishes_25N()
parishes_26N()

}
