% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run-ed50-analysis.R
\name{get_all_eds_by_grouping_property}
\alias{get_all_eds_by_grouping_property}
\title{Get ED5s, ED50s and ED95s by Grouping Property}
\usage{
get_all_eds_by_grouping_property(models)
}
\arguments{
\item{models}{A list of models where each element represents a model object containing coefficients.}
}
\value{
A data frame containing the ED50 values along with their corresponding grouping property. Each row represents a model's ED50 value and its associated grouping property.
}
\description{
This function takes a list of models and extracts the ED5s,
ED50s and ED95s values for each model based on a specified grouping
property. The ED5s, ED50s and ED95s values is extracted from
the model's coefficients and is associated with the intercept term.
}
\examples{
data(cbass_dataset)
preprocessed_data <- preprocess_dataset(cbass_dataset)
model_list <- fit_drms(preprocessed_data,
           c("Site", "Condition", "Species", "Genotype"),
            "Pam_value ~ Temperature", is_curveid = TRUE)
eds_data <- get_all_eds_by_grouping_property(model_list)

# Resulting data frame structure:
#   ED5         ED50         ED95         GroupingProperty
# 1 ED5_value_1 ED50_value_1 ED95_value_1 Group1
# 2 ED5_value_2 ED50_value_2 ED95_value_2 Group2
}
